#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//Progresive Penrose PentagramMod01.fsh   by   mikceroese  
//https://www.shadertoy.com/view/lctSRr
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

const float GR = (1.0+sqrt(5.0))/2.0; // Golden ratio, diagonal of regular pentagon
const float GRI = 1.0/GR; // Inverse of the golden ratio
const float PI = 3.14159265; // Pi (duh)
const float DG_72 = PI/2.5; // 72 degrees
const float DG_36 = PI/5.0; // 36 degrees
const float COS_DG_36 = cos(DG_36); // Cosine of 36 degrees
const float SIN_DG_36 = sin(DG_36); // Sine of 36 degrees
const float DG_18 = PI/10.0; // 18 degrees

const vec2 SUN_TRI_A = vec2(0,0); // First half-dart vertex
const vec2 SUN_TRI_B = vec2(1,0); // Second half-dart vertex
const vec2 SUN_TRI_C = vec2(cos(DG_36),sin(DG_36)); // Third half-dart vertex
const float SUN_TRI_AREA = sin(DG_18)*cos(DG_18); // Area of a half-dart at step 0

void triangle_area(out float area, out float height, in vec2 A, in vec2 B, in vec2 C)
{
    //Returns the area of a triangle,
    //its height (assuming the B-C is the base)
    area = abs((A.x*(B.y-C.y) + B.x*(C.y-A.y) + C.x*(A.y-B.y))/2.0);
    height = 2.0*area/length(B-C);
}

void project_p_to_line(out float rel_proj, in vec2 P, in vec2 A, in vec2 B)
{
    //Returns the relative position of P's projection in the A-B line.
    //(With a projection on A and B being a 0 and a 1, respectively)

    vec2 ab = B-A;
    vec2 ap = P-A;
    float mag_ab = length(ab);

    rel_proj = dot(ap,ab)/(mag_ab*mag_ab);

}

void is_p_in_tri(out bool is_in, out float dist, in vec2 P, in float target_area, in vec2 A, in vec2 B, in vec2 C)
{
    //Returns whether or not a point lies within a triangle of a given area, 
    //and how far it is from its nearest side.
    
    float area = 0.0, new_area;
    float min_dist = 1.0, new_dist;
    
    triangle_area(new_area,new_dist,P,A,B);
    min_dist = min(min_dist,new_dist);
    area += new_area;
    triangle_area(new_area,new_dist,P,B,C);
    min_dist = min(min_dist,new_dist);
    area += new_area;
    triangle_area(new_area,new_dist,P,C,A);
    min_dist = min(min_dist,new_dist);
    area += new_area;
    
    dist = min_dist;    
    
    float area_diff = abs(area-target_area);
    if(area_diff<1e-6){    
        is_in = true;
    } else {
        is_in = false;
    }
    
}

void kite_or_dart(out float tile, out float dist, in float r, in float phi, in float steps){
    // tile: Output 1 if the tile is a kite, or 0 if it is a dart.
    // For steps with decimal part, tile is interpolated between the floor and ceil of steps.
    // dist: Output the distance to the nearest side of the tile.
    // For steps with decimal part, dist will consider unfinished sides and output
    // the next shortest distance to a finished side.
    
    // Map every input to the same half-dart (radial simmetry, yay!)
    // Angles are mirrored every 2 half-darts: 0º to 36º and back to 0º
    float new_phi = DG_36-abs(DG_36-(mod(phi,DG_72)));
    // Radii are constrained to the triangle
    // Small values are bumped up a little
    // Big values are brought down to prevent them from strayin too far,
    // down to the distance to the point of intersection between 
    // the uv vector and the far side of the triangle (or smaller)
    float max_r = 1.0/(cos(new_phi)-sin(new_phi)*(COS_DG_36-1.0)/SIN_DG_36);
    //float new_r = clamp(r,1e-6,max_r); // Using this one produces black outside
    float new_r = max_r-abs(max_r-mod(r,2.0*max_r)); // This one mirrors the pattern outside-in
    
    vec2 uv = new_r*vec2(cos(new_phi),sin(new_phi));
    
    // The area of the tiles is always reduced by the inverse of the
    // golden ratio every step, so you know the area they should
    // have if you count the steps
    float target_dart_area = SUN_TRI_AREA;
    float target_kite_area = 0.0;
    
    // The Penrose Sun always starts as 10 half-darts
    bool is_kite_ceil = false;
    bool is_kite_floor = false;
    float floor_dist = 1.0;
    float ceil_dist = 1.0;
    vec2 a = SUN_TRI_A;
    vec2 b = SUN_TRI_B;
    vec2 c = SUN_TRI_C;
    
    vec2 d, e, f;
    vec2 cut_start, cut_stop;
    float a1, a2, h1, h2;

    d = a+(b-a)/GR;
    e = b+(a-b)/GR;
    f = b+(c-b)/GR;

    bool is_in;
    
    float i = 0.0;
    
    // At every step
    while (i<ceil(steps)){
        // Precalc the area of kites and darts for next step
        target_kite_area = target_dart_area*GRI;
        target_dart_area = target_dart_area*(1.0-GRI);
        is_kite_floor = is_kite_ceil;
        floor_dist = ceil_dist;
        // Split the current triangle
        if (is_kite_floor){
            // For kites, we need two cuts
            is_p_in_tri(is_in,ceil_dist,uv,target_kite_area,f,c,a);
            cut_start = a;
            cut_stop = f;
            if(is_in){
                b = c;
                c = a;
                a = f;
                //is_kite_ceil = true;
            } else {
                is_p_in_tri(is_in,ceil_dist,uv,target_kite_area,e,f,b);
                if(is_in){
                    cut_start = e;
                    cut_stop = f;
                    c = b;
                    a = e;
                    b = f;
                    //is_kite_ceil = true;
                } else {
                    is_p_in_tri(is_in,ceil_dist,uv,target_dart_area,f,e,a);
                    triangle_area(a1,h1,uv,a,f);
                    triangle_area(a2,h2,uv,e,f);
                    if(h1>h2){
                        cut_start = e;
                        cut_stop = f;
                    }
                    c = a;
                    a = f;
                    b = e;
                    is_kite_ceil = false;
                }
            }
        }else{
            // For darts, we need one cut
            is_p_in_tri(is_in,ceil_dist,uv,target_kite_area,d,c,a);
            cut_start = d;
            cut_stop = c;
            if(is_in){
                b = c;
                c = a;
                a = d;
                is_kite_ceil = true;                
            } else {
                is_p_in_tri(is_in,ceil_dist,uv,target_dart_area,c,d,b);
                a = c;
                c = b;
                b = d;
                //is_kite_ceil = false;
            }
        }
        
        i += 1.0;

        // Update the cut points for next iteration
        d = a+(b-a)/GR;
        e = b+(a-b)/GR;
        f = b+(c-b)/GR;

    }
    
    float p_proj;
    project_p_to_line(p_proj,uv,cut_start,cut_stop);
    //float dist_factor = float(p_proj<(steps-floor(steps)));
    float dist_factor = 1.0-smoothstep(max(0.0,steps-floor(steps)-0.05),min(1.0,steps-floor(steps)+0.05),p_proj);
    dist = dist_factor*min(floor_dist,ceil_dist) + (1.0-dist_factor)*floor_dist;
    tile = float(is_kite_floor)*(1.0-steps+floor(steps)) + float(is_kite_ceil)*(1.0-ceil(steps)+steps);
        
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
    // Normalized pixel coordinates (from 0 to 1)
    vec2 uv = (fragCoord *2.0 - iResolution.xy) / iResolution.y;
    // Obtain distance to center and angle from +X axis
    float r = length(uv);
    float phi = atan(uv.x,uv.y) + PI;
    // Define the number of subdivisions
    float max_steps = 4.000;
    float steps = 1.0001 + ((sin(iTime)+1.0)/2.0)*max_steps;
    
    float tile;
    float d;
    
    phi += sin(iTime*0.2+1.0) + r*sin(iTime*0.2);
    
    kite_or_dart(tile,d,r,phi,steps);
    
    d = steps*sqrt(d)/sqrt(r);
    
    vec3 color = vec3((0.5 + 0.1*tile)/d,(0.3 - 0.2*tile)/d,(0.4 + 0.1*tile)/d);
    //vec3 color = vec3(d,d,d);

    // Output to screen
    fragColor = vec4(0.6*color,1.0);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below 
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

